/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_cancel.c,v 1.17 2005/06/29 00:23:16 eugene Exp $";

#include <pthread.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t
mx_cancel(mx_endpoint_t endpoint, mx_request_t * handlep, uint32_t *result)
{
  struct mx_endpoint *pp;
  struct mx_post *post;
  mx_request_t handle = *handlep;

  pthread_mutex_lock(&Mx_po_lock);

  pp = (struct mx_endpoint *)endpoint;

  /* look for the completed post */
  for (post = pp->completed_posts.next;
       post != &pp->completed_posts;
       post = post->next) {
    if (post == &handle->post) {
      goto handle_found;
    }
  }

  pthread_mutex_unlock(&Mx_po_lock);

  return (MX_BAD_REQUEST);

 handle_found:
  if (!post->complete) {
    /* pull the post off the list */
    MX_LIST_REMOVE(post);
    /* destroy this handle */
    mx_destroy_post(post);
    pthread_mutex_unlock(&Mx_po_lock);
    /* TODO: cancel shouldn't fail, send message to other side. */
    return MX_FAILURE;
  }
  else {
    *result = 1;
    pthread_mutex_unlock(&Mx_po_lock);
    return MX_SUCCESS;
  }
  return MX_FAILURE;
}
